/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.ECFilter;
import com.ibm.hwmca.base.updates.ECStream;
import com.ibm.hwmca.base.updates.MCL;
import com.ibm.hwmca.base.updates.MCLDataFileFilter;
import com.ibm.hwmca.base.updates.MCLErrorIds;
import com.ibm.hwmca.base.updates.NewMCLDataFileFilter;
import com.ibm.hwmca.base.updates.RsfRequestCompleted;
import com.ibm.hwmca.base.updates.RsfResultsHandler;
import com.ibm.hwmca.base.updates.UpdateUtilities;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.E4EventLog;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.rsf.RsfManager;
import com.ibm.hwmca.fw.rsf.RsfRequest;
import com.ibm.hwmca.fw.rsf.RsfResult;
import com.ibm.hwmca.fw.util.BinaryNumber;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.Translator;
import com.ibm.hwmca.xfw.rsf.MicrocodeFunctionRequestBody;
import com.ibm.hwmca.xfw.updates.UpdateLevel;
import com.ibm.hwmca.xfw.updates.UpdateManager;
import com.ibm.hwmca.xfw.updates.UpdateRange;
import com.ibm.hwmca.xfw.updates.Updater;
import com.ibm.hwmca.xfw.updates.UpdaterEvent;
import com.ibm.hwmca.xfw.updates.UpdatesOwner;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class BaseUpdater
extends Updater
implements MCLErrorIds,
RsfRequestCompleted {
    private static final String TRACE_MASKT = "XMCLB  T";
    private static final String TRACE_MASKF = "XMCLB  F";
    private static final String TRACE_MASKD = "XMCLB  D";
    private static final int XMCL_BEYOND_MAXIMUM_LEVEL = 10000;
    private static final int XMCL_DOING_IMPORT = 1;
    private static final int XMCL_DOING_EXPORT = 2;
    private static final int XMCL_DOING_RECALL = 3;
    private static final int XMCL_TO_STAGING_ONLY = 4;
    private static final String ON_HOLD_FILES = "IQZMHOLD.DAT";
    private static final FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(2, "XMCL");
    private static String XMCL_MEDIA_REPOSITORY = "/mcl/";
    public static final String ATTRIBUTE_DURATION = "duration";
    private String distributionStagingArea;
    private String updateStagingArea;
    private String bundleName;
    private File exportMountPoint;
    private RsfResult rsfResult;

    public BaseUpdater(UpdatesOwner owner) {
        super(owner);
        try {
            this.distributionStagingArea = BaseFileControl.getFilePath("tmp");
            this.updateStagingArea = BaseFileControl.getFilePath("iqzmcf.mcf");
        }
        catch (HException hexc) {
            this.logError("Unable to access staging area", (short)-3954, hexc);
        }
        this.bundleName = new String("com/ibm/hwmca/base/res/message");
        Trace.trace(TRACE_MASKT, "<> BaseUpdater()");
    }

    public void cancel() {
    }

    private void deleteUpdatesFromStagingArea(String stagingAreaPath) {
        String[] newFiles;
        Trace.trace(TRACE_MASKT, "-> deleteUpdatesFromStagingArea()");
        File stagingArea = new File(stagingAreaPath);
        String[] files = stagingArea.list(new MCLDataFileFilter());
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                Trace.trace(TRACE_MASKD, "MCL data file " + files[i] + " has been found.");
                File fileToDelete = new File(stagingAreaPath + files[i]);
                fileToDelete.delete();
                Trace.trace(TRACE_MASKD, "MCL data file " + stagingAreaPath + files[i] + " has been deleted.");
                int dotPosition = files[i].indexOf(".");
                String ecNumber = files[i].substring(1, dotPosition);
                String coverLetter = "C" + ecNumber + "0" + files[i].substring(dotPosition);
                fileToDelete = new File(stagingAreaPath + coverLetter);
                fileToDelete.delete();
                Trace.trace(TRACE_MASKD, "MCL cover letter " + stagingAreaPath + coverLetter + " has been deleted.");
                ++i;
            }
        }
        if ((newFiles = stagingArea.list(new NewMCLDataFileFilter())) != null) {
            int i = 0;
            while (i < newFiles.length) {
                Trace.trace(TRACE_MASKD, "MCL data file " + newFiles[i] + " has been found.");
                File fileToDelete = new File(stagingAreaPath + newFiles[i]);
                fileToDelete.delete();
                Trace.trace(TRACE_MASKD, "MCL data file " + stagingAreaPath + newFiles[i] + " has been deleted.");
                ++i;
            }
        }
        Trace.trace(TRACE_MASKT, "<- deleteUpdatesFromStagingArea()");
    }

    public void downloadRemoteUpdatesToStagingArea(Collection levels) {
        Trace.trace(TRACE_MASKT, "-> downloadRemoteUpdatesToStagingArea()");
        ArrayList<UpdateRange> ranges = new ArrayList<UpdateRange>();
        Iterator counterOfStreams = levels.iterator();
        while (counterOfStreams.hasNext()) {
            UpdateLevel nextStream = (UpdateLevel)counterOfStreams.next();
            String ecNumber = nextStream.getUpdateableComponentECNumber();
            int lastLevelToDo = nextStream.getLevel();
            int firstLevelToDo = nextStream.getLevel() + 1;
            ranges.add(new UpdateRange(ecNumber, firstLevelToDo, -1));
        }
        if (ranges.size() > 0) {
            final ArrayList<UpdateRange> importRanges = ranges;
            int function = 4;
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    BaseUpdater.this.importRemoteUpdatesSynchronously(importRanges, 4);
                }
            }, "Asynchronous importRemoteUpdates recall operation");
            thread.setDaemon(true);
            thread.start();
        }
        Trace.trace(TRACE_MASKT, "<- downloadRemoteUpdatesToStagingArea()");
    }

    public void exportUpdatesToMedia(File mountPoint, int mediaType, Collection levels) {
        Trace.trace(TRACE_MASKT, "-> exportUpdatesToMedia()");
        this.exportMountPoint = mountPoint;
        this.importRemoteUpdateRanges(levels, true);
        Trace.trace(TRACE_MASKT, "<- exportUpdatesToMedia()");
    }

    public Collection getLatestUpdateLevelsFromMedia(File mountPoint, int mediaType, Collection ecNumbers) {
        Trace.trace(TRACE_MASKT, "-> getLatestUpdateLevelsFromMedia()");
        ArrayList<UpdateLevel> latestLevels = new ArrayList<UpdateLevel>();
        String mediaStagingArea = mountPoint + XMCL_MEDIA_REPOSITORY;
        File stagingArea = new File(mediaStagingArea);
        Iterator counterOfECs = ecNumbers.iterator();
        while (counterOfECs.hasNext()) {
            int dotPosition;
            int i;
            String ecNumber = (String)counterOfECs.next();
            String[] files = stagingArea.list(new MCLDataFileFilter(ecNumber, 1, 10000));
            String[] newFiles = stagingArea.list(new NewMCLDataFileFilter(ecNumber, 1, 10000));
            if (files == null && newFiles == null) continue;
            int[] levelsFound = new int[files.length + newFiles.length];
            int numberOfLevelsFound = 0;
            if (files != null) {
                i = 0;
                while (i < files.length) {
                    Trace.trace(TRACE_MASKF, "MCL data file " + files[i] + " has been found.");
                    dotPosition = files[i].indexOf(".");
                    String coverLetter = "C" + ecNumber + "0" + files[i].substring(dotPosition);
                    Trace.trace(TRACE_MASKF, "coverLetter=[" + coverLetter + "].");
                    File coverLetterFile = new File(mediaStagingArea + coverLetter);
                    if (coverLetterFile.exists()) {
                        int level = Integer.parseInt(files[i].substring(dotPosition + 1), 10);
                        Trace.trace(TRACE_MASKD, "level found = " + level);
                        boolean inserted = false;
                        int indexToAdd = 0;
                        while (!inserted && indexToAdd < numberOfLevelsFound) {
                            int nextLevel = levelsFound[indexToAdd];
                            if (level < nextLevel) {
                                Trace.trace(TRACE_MASKD, "Adding to the list at index = " + indexToAdd);
                                int idx = numberOfLevelsFound - 1;
                                while (idx >= indexToAdd) {
                                    levelsFound[idx + 1] = levelsFound[idx];
                                    --idx;
                                }
                                levelsFound[indexToAdd] = level;
                                ++numberOfLevelsFound;
                                inserted = true;
                            }
                            ++indexToAdd;
                        }
                        if (!inserted) {
                            Trace.trace(TRACE_MASKD, "Adding the level at the end of the list.");
                            levelsFound[numberOfLevelsFound] = level;
                            ++numberOfLevelsFound;
                        }
                    }
                    ++i;
                }
            }
            if (newFiles != null) {
                i = 0;
                while (i < newFiles.length) {
                    Trace.trace(TRACE_MASKF, "MCL data file " + newFiles[i] + " has been found.");
                    dotPosition = newFiles[i].indexOf(".");
                    int nextDotPosition = newFiles[i].indexOf(".", dotPosition + 1);
                    int level = Integer.parseInt(newFiles[i].substring(dotPosition + 1, nextDotPosition), 10);
                    Trace.trace(TRACE_MASKD, "level found = " + level);
                    boolean inserted = false;
                    int indexToAdd = 0;
                    while (!inserted && indexToAdd < numberOfLevelsFound) {
                        int nextLevel = levelsFound[indexToAdd];
                        if (level < nextLevel) {
                            Trace.trace(TRACE_MASKD, "Adding to the list at index = " + indexToAdd);
                            int idx = numberOfLevelsFound - 1;
                            while (idx >= indexToAdd) {
                                levelsFound[idx + 1] = levelsFound[idx];
                                --idx;
                            }
                            levelsFound[indexToAdd] = level;
                            ++numberOfLevelsFound;
                            inserted = true;
                        }
                        ++indexToAdd;
                    }
                    if (!inserted) {
                        Trace.trace(TRACE_MASKD, "Adding the level at the end of the list.");
                        levelsFound[numberOfLevelsFound] = level;
                        ++numberOfLevelsFound;
                    }
                    ++i;
                }
            }
            if (numberOfLevelsFound == 0) continue;
            int lastContinuousLevel = levelsFound[0];
            int currentIndex = 1;
            boolean done = false;
            while (!done && currentIndex < numberOfLevelsFound) {
                int nextLevel = levelsFound[currentIndex];
                if (nextLevel == lastContinuousLevel + 1) {
                    nextLevel = lastContinuousLevel;
                } else {
                    done = true;
                }
                ++currentIndex;
            }
            Trace.trace(TRACE_MASKF, "Level " + lastContinuousLevel + " is the highest found on media for EC " + ecNumber);
            UpdateLevel latestLevelOfEC = new UpdateLevel(ecNumber, lastContinuousLevel);
            latestLevels.add(latestLevelOfEC);
        }
        Trace.trace(TRACE_MASKT, "<- getLatestUpdateLevelsFromMedia()");
        return latestLevels;
    }

    public void importAllRemoteUnstagedUpdates(boolean forExporting) {
        Trace.trace(TRACE_MASKT, "-> importAllRemoteUnstagedUpdates()");
        UpdatesOwner updatesOwner = super.getOwner();
        List streams = new ArrayList();
        try {
            streams = updatesOwner.getUpdateableComponents();
        }
        catch (HException hexc) {
            this.logError("Failed getting EC streams " + hexc, (short)-3903, hexc);
        }
        ArrayList<UpdateLevel> levelsToProcess = new ArrayList<UpdateLevel>();
        ListIterator counterOfStreams = streams.listIterator();
        while (counterOfStreams.hasNext()) {
            ECStream nextEc = (ECStream)counterOfStreams.next();
            UpdateLevel nextLevel = new UpdateLevel(nextEc.getECNumber(), -1);
            levelsToProcess.add(nextLevel);
        }
        if (levelsToProcess.size() > 0) {
            this.importRemoteUpdatesThroughLevel(levelsToProcess, forExporting);
        }
        Trace.trace(TRACE_MASKT, "<- importAllRemoteUnstagedUpdates()");
    }

    public void importRemoteUpdatesThroughLevel(Collection levels, boolean forExporting) {
        Trace.trace(TRACE_MASKT, "-> importRemoteUpdatesThroughLevel()");
        ArrayList<UpdateRange> ranges = new ArrayList<UpdateRange>();
        UpdateManager manager = UpdateManager.getUpdateManager();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(3);
        String logInfo = null;
        Iterator counterOfStreams = levels.iterator();
        while (counterOfStreams.hasNext()) {
            UpdateLevel nextStream = (UpdateLevel)counterOfStreams.next();
            int lastLevelToDo = nextStream.getLevel();
            String ecNumber = nextStream.getUpdateableComponentECNumber();
            ECStream nextEc = (ECStream)manager.getComponentByECNumber(ecNumber);
            int firstLevelToDo = nextEc.getStagedLevel() + 1;
            if (firstLevelToDo == 0) {
                firstLevelToDo = 1;
            }
            ranges.add(new UpdateRange(ecNumber, firstLevelToDo, lastLevelToDo));
            logInfo = null == logInfo ? ecNumber + "." + nf.format(firstLevelToDo) : logInfo + " " + ecNumber + "." + nf.format(firstLevelToDo);
            logInfo = -1 == lastLevelToDo ? logInfo + "-ALL" : logInfo + "-" + nf.format(lastLevelToDo);
        }
        if (ranges.size() > 0) {
            if (!forExporting) {
                String[] substText = new String[]{logInfo};
                FrameworkEventText eventText = new FrameworkEventText(567, substText);
                new SystemEventLog(eventText, "MMCRET_IBMSS").log();
                new E4EventLog(eventText, "MMCRET_IBMSS").log();
            }
            this.importRemoteUpdateRanges(ranges, forExporting);
        }
        Trace.trace(TRACE_MASKT, "<- importRemoteUpdatesThroughLevel()");
    }

    public void importRemoteUpdateRanges(Collection ranges, boolean forExporting) {
        Trace.trace(TRACE_MASKT, "<> importRemoteUpdateRanges()");
        final Collection importLevels = ranges;
        final int function = forExporting ? 2 : 1;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                BaseUpdater.this.importRemoteUpdatesSynchronously(importLevels, function);
            }
        }, "Asynchronous importRemoteUpdates operation");
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void importRemoteUpdatesSynchronously(Collection ranges, int function) {
        Trace.trace("XMCLB  T", "-> importRemoteUpdatesSynchronously()");
        failed = false;
        done = false;
        importCollections = new ArrayList<MCL>();
        exportCollections = new ArrayList<UpdateRange>();
        request = new MicrocodeFunctionRequestBody();
        request.initializeMachineInformation();
        request.initializeUpdateList();
        if (function == 3) {
            request.setFunctionType('1');
        } else {
            request.setFunctionType('0');
        }
        rsfRanges = MicrocodeFunctionRequestBody.convertUpdateRangeCollection(ranges);
        request.setUpdateRangeList(rsfRanges);
        if (function == 2) {
            stagingAreaPath = this.distributionStagingArea;
            this.deleteUpdatesFromStagingArea(stagingAreaPath);
        } else {
            stagingAreaPath = this.updateStagingArea;
        }
        Trace.trace("XMCLB  D", "Asking RETAIN to go to a directory of [" + stagingAreaPath + "].");
        request.setStagingPathname(stagingAreaPath);
        rsf = RsfManager.getRsfManager().getConsoleRsf();
        id = " ";
        try {
            handler = new RsfResultsHandler();
            rsfRequest = rsf.newRequestInstance(request, handler.getClass().getName(), new LocalizableText(this.bundleName, "MCL0041"));
            id = rsfRequest.getId();
            RsfResultsHandler.register(id, this);
            var14_27 = this;
            synchronized (var14_27) {
                rsfRequest.submit();
                waitTime = 0;
                oldCount = -1;
                while (!done && waitTime < 60) {
                    try {
                        block87: {
                            block86: {
                                this.wait(60000L);
                                if (rsfRequest.getState() == 5) break block86;
                                if (rsfRequest.getState() != 4) break block87;
                            }
                            done = true;
                            continue;
                        }
                        ++waitTime;
                        updates = this.queryStagingAreaForUpdates(stagingAreaPath);
                        newCount = updates.size();
                        if (newCount == oldCount) continue;
                        key = new String("MCL0038");
                        parms = new String[]{String.valueOf(updates.size())};
                        message = new MessageText(this.bundleName, key, parms);
                        event = new UpdaterEvent(this);
                        event.setMessage(message);
                        super.fireOperationProgressing(event);
                    }
                    catch (InterruptedException e) {
                        if (rsfRequest.getState() != 5) {
                            if (rsfRequest.getState() != 4) continue;
                        }
                        done = true;
                    }
                }
            }
        }
        catch (Exception e) {
            this.logAndFireError("Error getting MCLs from retain " + e, (short)-3889, e);
            RsfResultsHandler.deregister(id);
            failed = true;
        }
        if (done) {
            rsfReturnCode = this.rsfResult.getStatusCode();
            rsfReasonCode = this.rsfResult.getReasonCode();
            Trace.trace("XMCLB  F", "rsfReturnCode = " + rsfReturnCode);
            if (rsfReturnCode != 1 && rsfReasonCode != 100) {
                failed = true;
                parms = new LocalizableText[1];
                if (rsfReturnCode == 5) {
                    parms[0] = new LocalizableText("No phone server capable of handling retrieve.");
                    Trace.trace("XMCLB  F", parms[0]);
                } else {
                    parms[0] = this.rsfResult.getStatusMessage();
                    Trace.trace("XMCLB  F", "Retrieve from retain failed due to +" + this.rsfResult.getStatusMessage());
                }
                key = new String("MCL0040");
                message = new MessageText("com/ibm/hwmca/base/res/message", key, parms);
                event = new UpdaterEvent(this);
                event.setMessage(message);
                event.setCompletionStatus(2);
                super.fireOperationCompleted(event);
            }
        }
        if (!failed) {
            if (!done) {
                this.logAndFireError("Retain timed out", (short)-3890);
                RsfResultsHandler.deregister(id);
                failed = true;
            } else if (function == 2) {
                exportDirectory = this.exportMountPoint + BaseUpdater.XMCL_MEDIA_REPOSITORY;
                Trace.trace("XMCLB  D", "exportDirectory=[" + exportDirectory + "].");
                directoryAsFile = new File(exportDirectory);
                if (!directoryAsFile.exists()) {
                    built = directoryAsFile.mkdir();
                    Trace.trace("XMCLB  F", (built != false ? "Created" : "Failed to create") + " " + exportDirectory);
                    if (!built) {
                        key = new String("MCL0054");
                        parms = new String[]{"Unable to create fix repository on media."};
                        message = new MessageText(this.bundleName, key, parms);
                        event = new UpdaterEvent(this);
                        event.setMessage(message);
                        super.fireOperationCompleted(event);
                        done = true;
                        failed = true;
                    }
                }
                stagingArea = new File(this.distributionStagingArea);
                counterOfRanges = ranges.iterator();
                while (counterOfRanges.hasNext() && !failed) {
                    nextRange = (UpdateRange)counterOfRanges.next();
                    ecNumber = nextRange.getUpdateableComponentECNumber();
                    firstLevel = nextRange.getFirstLevel();
                    lastLevel = nextRange.getLastLevel();
                    lastWrittenLevel = -1;
                    if (lastLevel == -1) {
                        lastLevel = 10000;
                    }
                    if ((files = stagingArea.list(new MCLDataFileFilter(ecNumber, firstLevel, lastLevel))) != null) {
                        done = false;
                        i = 0;
                        while (i < files.length && !done) {
                            Trace.trace("XMCLB  F", "MCL data file " + files[i] + " has been found.");
                            dotPosition = files[i].indexOf(".");
                            coverLetter = "C" + ecNumber + "0" + files[i].substring(dotPosition);
                            Trace.trace("XMCLB  F", "coverLetter=[" + coverLetter + "].");
                            coverLetterFile = new File(this.distributionStagingArea + coverLetter);
                            if (coverLetterFile.exists()) {
                                try {
                                    UpdateUtilities.copyFile(this.distributionStagingArea + coverLetter, exportDirectory + coverLetter.toUpperCase());
                                    UpdateUtilities.copyFile(this.distributionStagingArea + files[i], exportDirectory + files[i].toUpperCase());
                                    lastWrittenLevel = Integer.parseInt(files[i].substring(dotPosition + 1), 10);
                                }
                                catch (IOException hexc) {
                                    key = new String("MCL0054");
                                    parms = new String[]{String.valueOf(hexc)};
                                    message = new MessageText(this.bundleName, key, parms);
                                    event = new UpdaterEvent(this);
                                    event.setMessage(message);
                                    super.fireOperationCompleted(event);
                                }
                            }
                            ++i;
                        }
                    }
                    if ((newFiles = stagingArea.list(new NewMCLDataFileFilter(ecNumber, firstLevel, lastLevel))) != null) {
                        done = false;
                        i = 0;
                        while (i < newFiles.length && !done) {
                            Trace.trace("XMCLB  F", "MCL data file " + newFiles[i] + " has been found.");
                            try {
                                UpdateUtilities.copyFile(this.distributionStagingArea + newFiles[i], exportDirectory + newFiles[i]);
                                dotPosition1 = newFiles[i].indexOf(".");
                                dotPosition2 = newFiles[i].indexOf(".", dotPosition1 + 1);
                                if (dotPosition2 != -1) {
                                    idString = newFiles[i].substring(dotPosition1 + 1, dotPosition2);
                                    lastWrittenLevel = Integer.parseInt(idString, 10);
                                }
                            }
                            catch (IOException hexc) {
                                key = new String("MCL0054");
                                parms = new String[]{String.valueOf(hexc)};
                                message = new MessageText(this.bundleName, key, parms);
                                event = new UpdaterEvent(this);
                                event.setMessage(message);
                                super.fireOperationCompleted(event);
                                done = true;
                                failed = true;
                            }
                            ++i;
                        }
                    }
                    if (lastWrittenLevel == -1) continue;
                    writtenRange = new UpdateRange(ecNumber, firstLevel, lastWrittenLevel);
                    exportCollections.add(writtenRange);
                }
            } else if (function == 3) {
                onholdFile = " ";
                instream = null;
                manager = UpdateManager.getUpdateManager();
                try {
                    onHoldPath = BaseFileControl.getFilePath("IQZMHOLD.DAT");
                    onHoldFile = onHoldPath + "IQZMHOLD.DAT";
                    instream = new BufferedInputStream(new FileInputStream(onHoldFile));
                    byteHoldCount = new byte[2];
                    this.readFully(instream, byteHoldCount);
                    holdCount = BinaryNumber.toUnsignedShort(BinaryNumber.swapByteOrder(byteHoldCount));
                    byteEC = new byte[6];
                    byteLevel = new byte[3];
                    index = 0;
                    levelsToProcess = new ArrayList<UpdateLevel>();
                    while (index < holdCount) {
                        this.readFully(instream, byteEC);
                        ecNumber = Translator.fromEbcdic(byteEC);
                        this.readFully(instream, byteLevel);
                        levelString = Translator.fromEbcdic(byteLevel);
                        level = Integer.parseInt(levelString);
                        Trace.trace("XMCLB  F", "On hold MCL: " + ecNumber + "." + levelString);
                        nextEc = (ECStream)manager.getComponentByECNumber(ecNumber);
                        if (nextEc != null) {
                            retrievedLevel = nextEc.getStagedLevel();
                            activatedLevel = nextEc.getAppliedLevel();
                            if (level > activatedLevel && level <= retrievedLevel) {
                                nextLevel = new UpdateLevel(ecNumber, level);
                                levelsToProcess.add(nextLevel);
                            }
                        }
                        ++index;
                    }
                    if (levelsToProcess.size() <= 0) ** GOTO lbl312
                    utilities = new UpdateUtilities();
                    utilities.deleteStagedCollections(levelsToProcess);
                }
                catch (FileNotFoundException fnfe) {
                    Trace.trace("XMCLB  D", "No MCLs are on hold");
                }
                catch (IOException e) {
                    this.logAndFireError("IO error =" + e, (short)-3888);
                    failed = true;
                }
                catch (HException e) {
                    this.logAndFireError("IO error =" + e, (short)-3886);
                    failed = true;
                }
                finally {
                    if (null != instream) {
                        try {
                            instream.close();
                        }
                        catch (IOException e) {
                            this.logAndFireError("Error on close of on hold MCLs =" + e, (short)-3887);
                            failed = true;
                        }
                    }
                }
            } else if (function == 1) {
                stagingArea = new File(this.updateStagingArea);
                manager = UpdateManager.getUpdateManager();
                counterOfStreams = ranges.iterator();
                while (counterOfStreams.hasNext() && !failed) {
                    nextStream = (UpdateRange)counterOfStreams.next();
                    lastLevelToDo = nextStream.getLastLevel();
                    if (lastLevelToDo == -1) {
                        lastLevelToDo = 10000;
                    }
                    if ((firstLevelToDo = (nextEc = (ECStream)manager.getComponentByECNumber(ecNumber = nextStream.getUpdateableComponentECNumber())).getStagedLevel() + 1) == 0) {
                        firstLevelToDo = 1;
                    }
                    done = false;
                    level = firstLevelToDo;
                    while (!done && level <= lastLevelToDo) {
                        files = stagingArea.list(new NewMCLDataFileFilter(ecNumber, level, level));
                        if (files.length == 0 && (files = stagingArea.list(new MCLDataFileFilter(ecNumber, level, level))).length == 0) {
                            done = true;
                        }
                        if (!done) {
                            try {
                                collection = new MCL(nextEc, level);
                                importCollections.add(collection);
                            }
                            catch (HException hexc) {
                                this.logAndFireError("Error creating MCL " + hexc, (short)-3898, hexc);
                                done = true;
                                failed = true;
                            }
                        }
                        ++level;
                    }
                }
            } else {
                Trace.trace("XMCLB  F", "Files should now be available in staging area");
                stagingArea = new File(this.distributionStagingArea);
                counterOfRanges = ranges.iterator();
                while (counterOfRanges.hasNext() && !failed) {
                    nextRange = (UpdateRange)counterOfRanges.next();
                    ecNumber = nextRange.getUpdateableComponentECNumber();
                    firstLevel = nextRange.getFirstLevel();
                    lastLevel = nextRange.getLastLevel();
                    lastWrittenLevel = -1;
                    if (lastLevel == -1) {
                        lastLevel = 10000;
                    }
                    if ((files = stagingArea.list(new MCLDataFileFilter(ecNumber, firstLevel, lastLevel))) != null) {
                        done = false;
                        i = 0;
                        while (i < files.length && !done) {
                            Trace.trace("XMCLB  F", "MCL data file " + files[i] + " has been found.");
                            dotPosition = files[i].indexOf(".");
                            coverLetter = "C" + ecNumber + "0" + files[i].substring(dotPosition);
                            Trace.trace("XMCLB  F", "coverLetter=[" + coverLetter + "].");
                            coverLetterFile = new File(this.distributionStagingArea + coverLetter);
                            if (coverLetterFile.exists()) {
                                lastWrittenLevel = Integer.parseInt(files[i].substring(dotPosition + 1), 10);
                            }
                            ++i;
                        }
                    }
                    if ((newFiles = stagingArea.list(new NewMCLDataFileFilter(ecNumber, firstLevel, lastLevel))) != null) {
                        done = false;
                        i = 0;
                        while (i < newFiles.length && !done) {
                            Trace.trace("XMCLB  F", "MCL data file " + newFiles[i] + " has been found.");
                            dotPosition1 = newFiles[i].indexOf(".");
                            dotPosition2 = newFiles[i].indexOf(".", dotPosition1 + 1);
                            if (dotPosition2 != -1) {
                                idString = newFiles[i].substring(dotPosition1 + 1, dotPosition2);
                                lastWrittenLevel = Integer.parseInt(idString, 10);
                            }
                            ++i;
                        }
                    }
                    if (lastWrittenLevel == -1) continue;
                    writtenRange = new UpdateRange(ecNumber, firstLevel, lastWrittenLevel);
                    exportCollections.add(writtenRange);
                }
            }
lbl312:
            // 9 sources

            if (!failed) {
                key = new String("MCL0039");
                message = new MessageText(this.bundleName, key);
                event = new UpdaterEvent(this);
                event.setMessage(message);
                event.setCompletionStatus(1);
                event.setImportedUpdateCollections(importCollections);
                event.setExportedUpdateCollections(exportCollections);
                super.fireOperationCompleted(event);
            }
        }
        Trace.trace("XMCLB  T", "<- importRemoteUpdatesSynchronously()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRsfResult(RsfRequest request, RsfResult result) {
        Trace.trace(TRACE_MASKT, "-> setRsfResult()");
        BaseUpdater baseUpdater = this;
        synchronized (baseUpdater) {
            this.rsfResult = result;
            this.notify();
        }
        Trace.trace(TRACE_MASKT, "<- setRsfResult()");
    }

    public RsfResult getRsfResult() {
        return this.rsfResult;
    }

    public void importAllUnstagedUpdatesFromMedia(File mountPoint, int mediaType) {
        Trace.trace(TRACE_MASKT, "-> importAllUnstagedUpdatesFromMedia()");
        UpdatesOwner updatesOwner = super.getOwner();
        List streams = new ArrayList();
        try {
            streams = updatesOwner.getUpdateableComponents();
        }
        catch (HException hexc) {
            this.logError("Failed getting EC streams " + hexc, (short)-3903, hexc);
        }
        ArrayList<UpdateLevel> levelsToProcess = new ArrayList<UpdateLevel>();
        ListIterator counterOfStreams = streams.listIterator();
        while (counterOfStreams.hasNext()) {
            ECStream nextEc = (ECStream)counterOfStreams.next();
            UpdateLevel nextLevel = new UpdateLevel(nextEc.getECNumber(), -1);
            levelsToProcess.add(nextLevel);
        }
        if (levelsToProcess.size() > 0) {
            this.importUpdatesThroughLevelFromMedia(mountPoint, mediaType, levelsToProcess);
        }
        Trace.trace(TRACE_MASKT, "<- importAllUnstagedUpdatesFromMedia()");
    }

    public void importUpdatesThroughLevelFromMedia(File mountPoint, int mediaType, Collection levels) {
        Trace.trace(TRACE_MASKT, "-> importUpdatesThroughLevelFromMedia()");
        File mediaRepository = new File(mountPoint + XMCL_MEDIA_REPOSITORY);
        UpdateManager manager = UpdateManager.getUpdateManager();
        Iterator counterOfStreams = levels.iterator();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(3);
        String logInfo = null;
        int lowestLevelToLog = 0;
        int highestLevelToLog = 0;
        while (counterOfStreams.hasNext()) {
            String ecNumber;
            ECStream nextEc;
            int firstLevelToDo;
            UpdateLevel nextStream = (UpdateLevel)counterOfStreams.next();
            int lastLevelToDo = nextStream.getLevel();
            if (lastLevelToDo == -1) {
                lastLevelToDo = 10000;
            }
            if ((firstLevelToDo = (nextEc = (ECStream)manager.getComponentByECNumber(ecNumber = nextStream.getUpdateableComponentECNumber())).getStagedLevel() + 1) == 0) {
                firstLevelToDo = 1;
            }
            highestLevelToLog = 0;
            lowestLevelToLog = 10000;
            boolean done = false;
            int id = firstLevelToDo;
            while (!done && id <= lastLevelToDo) {
                String extension = nf.format(id);
                Trace.trace(TRACE_MASKD, "mediaRepository = [" + mediaRepository + "]");
                String[] files = mediaRepository.list(new ECFilter(extension));
                String coverLetter = "C" + ecNumber + "0." + extension;
                Trace.trace(TRACE_MASKF, "coverLetter=[" + coverLetter + "].");
                boolean foundCoverLetter = false;
                boolean foundDataFile = false;
                if (files != null) {
                    int i = 0;
                    while (i < files.length && !foundCoverLetter) {
                        if (files[i].equalsIgnoreCase(coverLetter)) {
                            Trace.trace(TRACE_MASKF, "Cover letter " + files[i] + " found.");
                            foundCoverLetter = true;
                        }
                        ++i;
                    }
                }
                if (foundCoverLetter) {
                    String data = "D" + ecNumber + "." + extension;
                    Trace.trace(TRACE_MASKF, "data=[" + data + "].");
                    int i = 0;
                    while (i < files.length && !foundDataFile) {
                        if (files[i].equalsIgnoreCase(data)) {
                            FrameworkEventText eventText;
                            String[] substText;
                            Trace.trace(TRACE_MASKF, "Data file " + files[i] + " found.");
                            foundDataFile = true;
                            try {
                                UpdateUtilities.copyFile(mountPoint + XMCL_MEDIA_REPOSITORY + coverLetter, this.updateStagingArea + coverLetter);
                                UpdateUtilities.copyFile(mountPoint + XMCL_MEDIA_REPOSITORY + data, this.updateStagingArea + data);
                                try {
                                    new MCL(nextEc, id);
                                }
                                catch (HException hexc) {
                                    this.logError("Error creating MCL " + hexc, (short)-3900, hexc);
                                    substText = new String[]{ecNumber + "." + nf.format(id)};
                                    eventText = new FrameworkEventText(577, substText);
                                    new SystemEventLog(eventText, "MMCRETRIFAIL").log();
                                    new E4EventLog(eventText, "MMCRETRIFAIL").log();
                                    done = true;
                                }
                            }
                            catch (IOException hexc) {
                                this.logError("Error copying file " + hexc, (short)-3901, hexc);
                                substText = new String[]{ecNumber + "." + nf.format(id)};
                                eventText = new FrameworkEventText(577, substText);
                                new SystemEventLog(eventText, "MMCRETRIFAIL").log();
                                new E4EventLog(eventText, "MMCRETRIFAIL").log();
                                done = true;
                            }
                        }
                        ++i;
                    }
                }
                if (!foundCoverLetter) {
                    String data = "D" + ecNumber + "." + extension + ".zip";
                    Trace.trace(TRACE_MASKF, "data=[" + mountPoint + XMCL_MEDIA_REPOSITORY + data + "].");
                    File newFile = new File(mountPoint + XMCL_MEDIA_REPOSITORY + data);
                    if (newFile.exists()) {
                        Trace.trace(TRACE_MASKF, "Data file " + data + " found.");
                        foundDataFile = true;
                        try {
                            UpdateUtilities.copyFile(mountPoint + XMCL_MEDIA_REPOSITORY + data, this.updateStagingArea + data);
                            try {
                                new MCL(nextEc, id);
                            }
                            catch (HException hexc) {
                                this.logError("Error creating MCL " + hexc, (short)-3900, hexc);
                                done = true;
                            }
                        }
                        catch (IOException hexc) {
                            this.logError("Error copying file " + hexc, (short)-3901, hexc);
                            done = true;
                        }
                    }
                }
                if (!foundDataFile) {
                    done = true;
                } else {
                    if (id < lowestLevelToLog) {
                        lowestLevelToLog = id;
                    }
                    if (id > highestLevelToLog) {
                        highestLevelToLog = id;
                    }
                }
                ++id;
            }
            if (highestLevelToLog <= 0) continue;
            logInfo = null == logInfo ? ecNumber + "." + nf.format(lowestLevelToLog) : logInfo + " " + ecNumber + "." + nf.format(lowestLevelToLog);
            if (highestLevelToLog == lowestLevelToLog) continue;
            logInfo = logInfo + "-" + nf.format(highestLevelToLog);
        }
        if (null != logInfo) {
            short eventId = 566;
            String eventName = "MMCRET_VCART";
            if (1 == mediaType) {
                eventId = 565;
                eventName = "MMCRET_DISK";
            }
            String[] substText = new String[]{logInfo};
            FrameworkEventText eventText = new FrameworkEventText(eventId, substText);
            new SystemEventLog(eventText, eventName).log();
            new E4EventLog(eventText, eventName).log();
        }
        Trace.trace(TRACE_MASKT, "<- importUpdatesThroughLevelFromMedia()");
    }

    public boolean isMediaApplicable(File mountPoint, int mediaType) {
        Trace.trace(TRACE_MASKT, "-> isMediaApplicable()");
        String importDirectory = mountPoint + XMCL_MEDIA_REPOSITORY;
        Trace.trace(TRACE_MASKF, "importDirectory=[" + importDirectory + "].");
        File checkDirectory = new File(importDirectory);
        boolean applicable = checkDirectory.isDirectory();
        Trace.trace(TRACE_MASKT, "<- isMediaApplicable returns " + (applicable ? "true" : "false"));
        return applicable;
    }

    public Collection listAllUnstagedUpdateFilesOnMedia(File mountPoint, int mediaType) {
        Trace.trace(TRACE_MASKT, "-> listAllUnstagedUpdateFilesOnMedia()");
        Collection updateFiles = new ArrayList();
        try {
            UpdatesOwner updatesOwner = super.getOwner();
            List streams = updatesOwner.getUpdateableComponents();
            ArrayList<UpdateLevel> levelsToProcess = new ArrayList<UpdateLevel>();
            ListIterator counterOfStreams = streams.listIterator();
            while (counterOfStreams.hasNext()) {
                ECStream nextEc = (ECStream)counterOfStreams.next();
                UpdateLevel nextLevel = new UpdateLevel(nextEc.getECNumber(), -1);
                levelsToProcess.add(nextLevel);
            }
            if (levelsToProcess.size() > 0) {
                updateFiles = this.listUpdateFilesThroughLevelOnMedia(mountPoint, mediaType, levelsToProcess);
            }
        }
        catch (HException hexc) {
            this.logError("Error getting EC streams.", (short)-3904, hexc);
        }
        Trace.trace(TRACE_MASKT, "<- listAllUnstagedUpdateFilesOnMedia()");
        return updateFiles;
    }

    public Collection listUpdateFilesThroughLevelOnMedia(File mountPoint, int mediaType, Collection levels) {
        Trace.trace(TRACE_MASKT, "-> listUpdateFilesThroughLevelOnMedia()");
        ArrayList<String> updateFiles = new ArrayList<String>();
        UpdateManager manager = UpdateManager.getUpdateManager();
        Trace.trace(TRACE_MASKD, "levels.size() = " + levels.size());
        File mediaRepository = new File(mountPoint + XMCL_MEDIA_REPOSITORY);
        Iterator counterOfStreams = levels.iterator();
        while (counterOfStreams.hasNext()) {
            String ecNumber;
            ECStream nextEc;
            int firstLevelToDo;
            UpdateLevel nextStream = (UpdateLevel)counterOfStreams.next();
            int lastLevelToDo = nextStream.getLevel();
            if (lastLevelToDo == -1) {
                lastLevelToDo = 10000;
            }
            if ((firstLevelToDo = (nextEc = (ECStream)manager.getComponentByECNumber(ecNumber = nextStream.getUpdateableComponentECNumber())).getStagedLevel() + 1) == 0) {
                firstLevelToDo = 1;
            }
            Trace.trace(TRACE_MASKD, "nextEc.getStagedLevel()=" + nextEc.getStagedLevel());
            Trace.trace(TRACE_MASKD, "ecNumber=[" + ecNumber + "] firstLevel=" + firstLevelToDo + " lastLevel=" + lastLevelToDo);
            boolean done = false;
            int id = firstLevelToDo;
            while (!done && id <= lastLevelToDo) {
                String tempString = "000" + id;
                String extension = tempString.substring(tempString.length() - 3);
                String[] files = mediaRepository.list(new ECFilter(extension));
                String coverLetter = "C" + ecNumber + "0." + extension;
                Trace.trace(TRACE_MASKF, "coverLetter=[" + coverLetter + "].");
                boolean foundCoverLetter = false;
                boolean foundDataFile = false;
                if (null != files) {
                    int i = 0;
                    while (i < files.length && !foundCoverLetter) {
                        Trace.trace(TRACE_MASKD, "i=" + i + ".");
                        if (files[i].equalsIgnoreCase(coverLetter)) {
                            Trace.trace(TRACE_MASKF, "Cover letter " + files[i] + " found.");
                            foundCoverLetter = true;
                        }
                        ++i;
                    }
                }
                if (foundCoverLetter) {
                    String data = "D" + ecNumber + "." + extension;
                    Trace.trace(TRACE_MASKF, "data=[" + data + "].");
                    int i = 0;
                    while (i < files.length && !foundDataFile) {
                        if (files[i].equalsIgnoreCase(data)) {
                            Trace.trace(TRACE_MASKF, "Data file " + files[i] + " found.");
                            foundDataFile = true;
                            updateFiles.add(mountPoint + XMCL_MEDIA_REPOSITORY + files[i]);
                        }
                        ++i;
                    }
                }
                if (!foundCoverLetter) {
                    String data = "D" + ecNumber + "." + extension + ".zip";
                    Trace.trace(TRACE_MASKF, "data=[" + data + "].");
                    File newFile = new File(mountPoint + XMCL_MEDIA_REPOSITORY + data);
                    if (newFile.exists()) {
                        Trace.trace(TRACE_MASKF, "Data file " + data + " found.");
                        foundDataFile = true;
                        updateFiles.add(mountPoint + XMCL_MEDIA_REPOSITORY + data);
                    }
                }
                if (!foundDataFile) {
                    done = true;
                }
                ++id;
            }
        }
        Trace.trace(TRACE_MASKT, "<- listUpdateFilesThroughLevelOnMedia()");
        return updateFiles;
    }

    protected void logAndFireError(String errorString, short errorId) {
        HException hexc = new HException(errorString);
        this.logAndFireError(errorString, errorId, hexc);
    }

    protected void logAndFireError(String errorString, short errorId, Exception exc) {
        this.logError(errorString, errorId, exc);
        HException hexc = new HException(exc);
        UpdaterEvent event = new UpdaterEvent(this);
        event.setMessage(super.getLastMessage());
        event.setCompletionStatus(2);
        super.fireOperationCompleted(event);
    }

    protected void logError(String errorString, short errorId, Exception hexc) {
        Trace.trace(TRACE_MASKD, "-> logError()");
        Trace.trace(TRACE_MASKF, errorString);
        new FrameworkLog(logInfo, errorId, hexc).log();
        this.setLastMessage(errorId);
        Trace.trace(TRACE_MASKD, "<- logError()");
    }

    public int queryAllRecalledUpdates() {
        Trace.trace(TRACE_MASKT, "-> queryAllRecalledUpdates()");
        UpdatesOwner updatesOwner = super.getOwner();
        List streams = new ArrayList();
        try {
            streams = updatesOwner.getUpdateableComponents();
        }
        catch (HException hexc) {
            this.logError("Failed getting EC streams " + hexc, (short)-3903, hexc);
        }
        ArrayList<UpdateRange> rangesToProcess = new ArrayList<UpdateRange>();
        ListIterator counterOfStreams = streams.listIterator();
        while (counterOfStreams.hasNext()) {
            ECStream nextEc = (ECStream)counterOfStreams.next();
            int firstLevelToDo = nextEc.getAppliedLevel();
            int lastLevelToDo = nextEc.getStagedLevel();
            if (firstLevelToDo == -1) {
                firstLevelToDo = 0;
            }
            if (lastLevelToDo == -1) {
                lastLevelToDo = 0;
            }
            if (lastLevelToDo < ++firstLevelToDo) continue;
            UpdateRange nextRange = new UpdateRange(nextEc.getECNumber(), firstLevelToDo, lastLevelToDo);
            rangesToProcess.add(nextRange);
        }
        if (rangesToProcess.size() > 0) {
            final ArrayList<UpdateRange> importRanges = rangesToProcess;
            int function = 3;
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    BaseUpdater.this.importRemoteUpdatesSynchronously(importRanges, 3);
                }
            }, "Asynchronous importRemoteUpdates recall operation");
            thread.setDaemon(true);
            thread.start();
        }
        Trace.trace(TRACE_MASKT, "<- queryAllRecalledUpdates() - streams to process = " + rangesToProcess.size());
        return rangesToProcess.size();
    }

    public List queryStagingAreaForUpdates(String stagingAreaPath) {
        String[] newFiles;
        Trace.trace(TRACE_MASKT, "-> queryStagingAreaForUpdates()");
        ArrayList<String> tempFiles = new ArrayList<String>();
        File stagingArea = new File(stagingAreaPath);
        String[] files = stagingArea.list(new MCLDataFileFilter());
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                Trace.trace(TRACE_MASKD, "MCL data file " + files[i] + " has been found.");
                tempFiles.add(files[i]);
                ++i;
            }
        }
        if ((newFiles = stagingArea.list(new NewMCLDataFileFilter())) != null) {
            int i = 0;
            while (i < newFiles.length) {
                Trace.trace(TRACE_MASKD, "MCL data file " + newFiles[i] + " has been found.");
                tempFiles.add(newFiles[i]);
                ++i;
            }
        }
        Trace.trace(TRACE_MASKT, "<- queryStagingAreaForUpdates()");
        return tempFiles;
    }

    protected void readFully(BufferedInputStream instream, byte[] buffer) throws IOException {
        this.readFully(instream, buffer, buffer.length);
    }

    protected void readFully(BufferedInputStream instream, byte[] buffer, int numberOfBytes) throws IOException {
        Trace.trace(TRACE_MASKF, "-> readFully()");
        int allBytesRead = 0;
        while (allBytesRead < numberOfBytes) {
            int bytesRead = instream.read(buffer, allBytesRead, numberOfBytes - allBytesRead);
            allBytesRead += bytesRead;
            Trace.trace(TRACE_MASKD, "<- read() read " + bytesRead + " bytes.");
        }
        Trace.trace(TRACE_MASKF, "<- readFully() read " + allBytesRead + " bytes.");
    }

    protected void setLastMessage(short errorId) {
        MessageText message;
        Trace.trace(TRACE_MASKD, "-> setLastMessage()");
        if (errorId == 27) {
            String key = new String("MCFHPATCH");
            message = new MessageText(this.bundleName, key);
        } else {
            String key = new String("MCL1724");
            message = new MessageText(this.bundleName, key);
        }
        super.setLastMessage(message);
        Trace.trace(TRACE_MASKD, "<- setLastMessage()");
    }

    static {
        try {
            XMCL_MEDIA_REPOSITORY = BaseFileControl.getFilePath("patchDir");
        }
        catch (HException e) {
            throw new IllegalArgumentException("BaseFileControl.getFilePath(\"patchDir\")");
        }
    }
}

